#version 330
#extension GL_EXT_gpu_shader4 : enable
// Trees of CirclesMod01.fsh  by  sl2c
//https://www.shadertoy.com/view/tsXBRf
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Copyright 2020 Google LLC
// SPDX-License-Identifier: Apache-2.0
// NOT an official Google project; see Google Open Source guidelines for more info on copyright transfer
// written by William Cadegan-Schlieper 

vec3 color(vec2 z, float ds) {
    int i;
    for (i=0; i<100; i++) {
        z.x = mod(z.x,4.0);
        if (z.x > 3.0) {
            z.x -= 4.0;
        }
        if (z.x > 1.0) {
            z.x = 2.0-z.x;
        }
        
        if (z.y < -1.0) {
            z.y = -2.0 - z.y;
        }
        if (z.y > 1.0) {
            break;
        }
        z /= -0.5 * dot(z,z);
        ds *= 0.5 * dot(z,z);
    }
    float col = 0.5 * min(1.0, (z.y - 1.0) / ds);
    if (i%2==0) {
        return vec3(0.5 + col);
    } else {
        return vec3(0.5 - col);
    }
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = 2.0 * (gl_FragCoord.xy - iResolution.xy * 0.5)/iResolution.y;
    float ds = 1.0 / iResolution.y;

    
    float t = iTime * 0.5;
    
    float period = 4.0 * log(2.0 + sqrt(5.0));
    while (t > period * 0.5) {
        t -= period;
    }
    
    
    
    uv *= exp(-t); ds *= exp(-t);
    
    uv.x -= sqrt(0.05);
    
    uv /= dot(uv,uv);
    ds *= dot(uv,uv);

    uv.x += sqrt(5.0);
    
    gl_FragColor = vec4(color(uv, ds),1.0);
    gl_FragColor = pow(gl_FragColor, vec4(1.0/2.2));
}